/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import jgamebase.db.Db;
import jgamebase.db.model.Item;
import jgamebase.db.model.ItemViewFilter;
import jgamebase.db.model.Music;
import jgamebase.db.model.Musician;
import jgamebase.db.model.Selection;
import jgamebase.gui.Gui;
import jgamebase.gui.ListListModel;
import jgamebase.gui.MusicianDialog;

public class MusicInfoDialog
extends JDialog {
    private static final long serialVersionUID = 9195909492712571939L;
    List<Item> list;
    Music music;
    boolean isList;
    Musician musician;
    private JCheckBox adultMusicCheckBox;
    private JPanel chooseMusicianPanel;
    private JCheckBox favouriteMusicCheckbox;
    private JCheckBox includeAdultMusicCheckbox;
    private JCheckBox includeFavouriteMusicCheckbox;
    private JCheckBox includeMusicianCheckbox;
    private JButton musicianButton;
    private JTextField musicianTextField;
    private JList musiciansList;
    private JTabbedPane propertiesPane;

    public MusicInfoDialog(Music music) {
        this.isList = false;
        this.music = music;
        this.initComponents();
        this.setSize(400, 480);
        this.selectIncludes(true);
        this.propertiesPane.remove(0);
        this.musician = music.getMusician();
        this.musicianTextField.setText(this.musician.getNameForDisplay());
        this.favouriteMusicCheckbox.setSelected(music.getIsFavourite());
        this.adultMusicCheckBox.setSelected(music.getIsAdult());
        this.setVisible(true);
    }

    public MusicInfoDialog(List<Item> list) {
        this.isList = true;
        this.list = list;
        this.initComponents();
        this.setSize(400, 480);
        this.selectIncludes(false);
        this.musician = Db.getMusicianById(38);
        this.musicianTextField.setText(this.musician.getNameForDisplay());
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void initComponents() {
        this.chooseMusicianPanel = new JPanel();
        JScrollPane jScrollPane3 = new JScrollPane();
        this.musiciansList = new JList();
        JButton newMusicianButton = new JButton();
        JButton editMusicianButton = new JButton();
        this.propertiesPane = new JTabbedPane();
        Gui.fixLookAndFeel(this.propertiesPane);
        JPanel includePanel = new JPanel();
        JPanel jPanel1 = new JPanel();
        this.includeMusicianCheckbox = new JCheckBox();
        this.includeFavouriteMusicCheckbox = new JCheckBox();
        this.includeAdultMusicCheckbox = new JCheckBox();
        JPanel jPanel2 = new JPanel();
        JButton includeAllButton = new JButton();
        JButton includeNoneButton = new JButton();
        JPanel fieldsPanel = new JPanel();
        JLabel musicianLabel = new JLabel();
        this.musicianTextField = new JTextField();
        this.musicianButton = new JButton();
        this.adultMusicCheckBox = new JCheckBox();
        this.favouriteMusicCheckbox = new JCheckBox();
        JPanel jPanel3 = new JPanel();
        JPanel OkCancelPanel = new JPanel();
        JPanel jPanel9 = new JPanel();
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        this.chooseMusicianPanel.setBorder(BorderFactory.createTitledBorder("Musicians"));
        this.chooseMusicianPanel.setLayout(new GridBagLayout());
        this.musiciansList.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.musiciansList.setSelectionMode(0);
        jScrollPane3.setViewportView(this.musiciansList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 5, 5, 5);
        this.chooseMusicianPanel.add((Component)jScrollPane3, gridBagConstraints);
        newMusicianButton.setMnemonic('N');
        newMusicianButton.setText("New");
        newMusicianButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MusicInfoDialog.this.newMusicianActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 5);
        this.chooseMusicianPanel.add((Component)newMusicianButton, gridBagConstraints);
        editMusicianButton.setMnemonic('E');
        editMusicianButton.setText("Edit");
        editMusicianButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MusicInfoDialog.this.editMusicianActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.chooseMusicianPanel.add((Component)editMusicianButton, gridBagConstraints);
        this.setTitle("Music Info Properties...");
        this.setModal(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MusicInfoDialog.this.exitFormWindowClosing(evt);
            }
        });
        includePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        includePanel.setLayout(new GridLayout(2, 1));
        jPanel1.setBorder(BorderFactory.createTitledBorder("Fields to update"));
        jPanel1.setLayout(new GridLayout(5, 1));
        this.includeMusicianCheckbox.setMnemonic('M');
        this.includeMusicianCheckbox.setText("Musician");
        this.includeMusicianCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MusicInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.includeMusicianCheckbox);
        this.includeFavouriteMusicCheckbox.setMnemonic('v');
        this.includeFavouriteMusicCheckbox.setText("Favourite Music");
        this.includeFavouriteMusicCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MusicInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.includeFavouriteMusicCheckbox);
        this.includeAdultMusicCheckbox.setMnemonic('u');
        this.includeAdultMusicCheckbox.setText("Adult Music");
        this.includeAdultMusicCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MusicInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.includeAdultMusicCheckbox);
        includePanel.add(jPanel1);
        jPanel2.setLayout(new FlowLayout(0));
        includeAllButton.setMnemonic('A');
        includeAllButton.setText("Select All");
        includeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MusicInfoDialog.this.selectAllIncludesActionPerformed(evt);
            }
        });
        jPanel2.add(includeAllButton);
        includeNoneButton.setMnemonic('N');
        includeNoneButton.setText("Select None");
        includeNoneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MusicInfoDialog.this.selectNoneIncludesActionPerformed(evt);
            }
        });
        jPanel2.add(includeNoneButton);
        includePanel.add(jPanel2);
        this.propertiesPane.addTab("Include", includePanel);
        fieldsPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        fieldsPanel.setLayout(new GridBagLayout());
        musicianLabel.setDisplayedMnemonic('M');
        musicianLabel.setLabelFor(this.musicianButton);
        musicianLabel.setText("Musician:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        fieldsPanel.add((Component)musicianLabel, gridBagConstraints);
        this.musicianTextField.setEditable(false);
        this.musicianTextField.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        fieldsPanel.add((Component)this.musicianTextField, gridBagConstraints);
        this.musicianButton.setText("...");
        this.musicianButton.setMargin(new Insets(0, 10, 0, 10));
        this.musicianButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MusicInfoDialog.this.chooseOrEditMusicianActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        fieldsPanel.add((Component)this.musicianButton, gridBagConstraints);
        this.adultMusicCheckBox.setMnemonic('u');
        this.adultMusicCheckBox.setText("Adult Music");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        fieldsPanel.add((Component)this.adultMusicCheckBox, gridBagConstraints);
        this.favouriteMusicCheckbox.setMnemonic('v');
        this.favouriteMusicCheckbox.setText("Favourite Music");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        fieldsPanel.add((Component)this.favouriteMusicCheckbox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        fieldsPanel.add((Component)jPanel3, gridBagConstraints);
        this.propertiesPane.addTab("Fields", fieldsPanel);
        this.getContentPane().add((Component)this.propertiesPane, "Center");
        OkCancelPanel.setLayout(new BorderLayout());
        jPanel9.setLayout(new FlowLayout(2));
        okButton.setMnemonic('O');
        okButton.setText("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MusicInfoDialog.this.okActionPerformed(evt);
            }
        });
        jPanel9.add(okButton);
        cancelButton.setMnemonic('C');
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MusicInfoDialog.this.cancelActionPerformed(evt);
            }
        });
        jPanel9.add(cancelButton);
        OkCancelPanel.add((Component)jPanel9, "South");
        this.getContentPane().add((Component)OkCancelPanel, "South");
        this.pack();
    }

    private void chooseOrEditMusicianActionPerformed(ActionEvent evt) {
        this.musiciansList.setModel(new ListListModel(new ItemViewFilter("Musician", 2, 3, 0, "Musicians", "MU_Id", "Musicians", "MU_Id").getSelections()));
        int i = 0;
        while (i < this.musiciansList.getModel().getSize()) {
            if (((Selection)this.musiciansList.getModel().getElementAt(i)).getValue().equals(String.valueOf(this.musician.getId()))) {
                this.musiciansList.setSelectedIndex(i);
                this.musiciansList.ensureIndexIsVisible(i);
            }
            ++i;
        }
        if (JOptionPane.showOptionDialog(this, this.chooseMusicianPanel, "Select Musician...", 2, -1, null, null, null) == 0) {
            this.musician = Db.getMusicianById(Integer.parseInt(((Selection)this.musiciansList.getSelectedValue()).getValue()));
            this.musicianTextField.setText(this.musician.getName());
        }
    }

    private void includesChangedActionPerformed(ActionEvent evt) {
        this.includesChanged();
    }

    private void selectAllIncludesActionPerformed(ActionEvent evt) {
        this.selectIncludes(true);
    }

    private void selectNoneIncludesActionPerformed(ActionEvent evt) {
        this.selectIncludes(false);
    }

    private void editMusicianActionPerformed(ActionEvent evt) {
        Musician newMusician = new MusicianDialog(Db.getMusicianById(Integer.parseInt(((Selection)this.musiciansList.getSelectedValue()).getValue()))).get();
        if (newMusician != null) {
            this.musician = newMusician;
            Db.saveOrUpdate(this.musician);
            this.musiciansList.setModel(new ListListModel(new ItemViewFilter("Musician", 2, 3, 0, "Musicians", "MU_Id", "Musicians", "MU_Id").getSelections()));
            int i = 0;
            while (i < this.musiciansList.getModel().getSize()) {
                if (((Selection)this.musiciansList.getModel().getElementAt(i)).getValue().equals(String.valueOf(this.musician.getId()))) {
                    this.musiciansList.setSelectedIndex(i);
                    this.musiciansList.ensureIndexIsVisible(i);
                }
                ++i;
            }
            this.musicianTextField.setText(this.musician.getName());
        }
    }

    private void newMusicianActionPerformed(ActionEvent evt) {
        Musician newMusician = new MusicianDialog().get();
        if (newMusician != null) {
            this.musician = newMusician;
            Db.saveOrUpdate(this.musician);
            this.musiciansList.setModel(new ListListModel(new ItemViewFilter("Musician", 2, 3, 0, "Musicians", "MU_Id", "Musicians", "MU_Id").getSelections()));
            int i = 0;
            while (i < this.musiciansList.getModel().getSize()) {
                if (((Selection)this.musiciansList.getModel().getElementAt(i)).getValue().equals(String.valueOf(this.musician.getId()))) {
                    this.musiciansList.setSelectedIndex(i);
                    this.musiciansList.ensureIndexIsVisible(i);
                }
                ++i;
            }
            this.musicianTextField.setText(this.musician.getName());
        }
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void selectIncludes(boolean b) {
        this.includeMusicianCheckbox.setSelected(b);
        this.includeFavouriteMusicCheckbox.setSelected(b);
        this.includeAdultMusicCheckbox.setSelected(b);
        this.includesChanged();
    }

    private void includesChanged() {
        this.musicianTextField.setEnabled(this.includeMusicianCheckbox.isSelected());
        this.musicianTextField.setBackground(this.includeMusicianCheckbox.isSelected() ? new Color(255, 255, 204) : UIManager.getDefaults().getColor("TextField.inactiveBackground"));
        this.musicianButton.setEnabled(this.includeMusicianCheckbox.isSelected());
        this.favouriteMusicCheckbox.setEnabled(this.includeFavouriteMusicCheckbox.isSelected());
        this.adultMusicCheckBox.setEnabled(this.includeAdultMusicCheckbox.isSelected());
    }

    private void okActionPerformed(ActionEvent evt) {
        if (!this.isList) {
            this.list = new ArrayList<Item>();
            this.list.add(this.music);
        }
        this.list.stream().filter(item -> item instanceof Music).map(item -> (Music)item).forEach(music -> {
            if (this.includeMusicianCheckbox.isSelected()) {
                music.setMusician(this.musician);
            }
            if (this.includeFavouriteMusicCheckbox.isSelected()) {
                music.setIsFavourite(this.favouriteMusicCheckbox.isSelected());
            }
            if (this.includeAdultMusicCheckbox.isSelected()) {
                music.setIsAdult(this.adultMusicCheckBox.isSelected());
            }
            Db.saveOrUpdate(music);
        });
        this.dispose();
    }

    private void exitFormWindowClosing(WindowEvent evt) {
        this.dispose();
    }
}

